//------------------------------------------------------------------------------
// main.h - Wadseeker Usage Example
//------------------------------------------------------------------------------
//
// Copyright (c) 2009, "Blzut3"
// Copyright (c) 2025, "Zalewa"
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//    * Redistributions of source code must retain the above copyright notice,
//      this list of conditions and the following disclaimer.
//    * Redistributions in binary form must reproduce the above copyright
//      notice, this list of conditions and the following disclaimer in the
//      documentation and/or other materials provided with the distribution.
//    * The name of the author may not be used to endorse or promote products
//      derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
// LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
// CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
// SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
// INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
// CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
// ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//------------------------------------------------------------------------------

#ifndef WADSEEKER_MAIN_H
#define WADSEEKER_MAIN_H

#include <QObject>

#include <wadseeker/wadseeker.h>

class WadseekerInterface : public QObject
{
	Q_OBJECT

public:
	enum State
	{
		S_PENDING,
		S_RUNNING,
		S_DONE_SUCCESS,
		S_DONE_FAILURE,
	};
	State state;

	WadseekerInterface(Wadseeker &wadseeker);

	bool parseFiles(const QStringList &files, /*out*/ ModSet &modSet);
	bool seek(const ModSet &modSet);

private:
	Wadseeker &wadseeker;
	int lastProgressReportLength;

private slots:
	void done(bool success);
	void downloadProgress(const ModFile &filename, qint64 done, qint64 total);
	void receiveMessage(const QString &msg, WadseekerLib::MessageType type);
};

#endif /* WADSEEKER_MAIN_H */
