//------------------------------------------------------------------------------
// cfgfilepaths.h
//------------------------------------------------------------------------------
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
// 02110-1301  USA
//
//------------------------------------------------------------------------------
// Copyright (C) 2009 "Zalewa" <zalewapl@gmail.com>
//------------------------------------------------------------------------------

#ifndef __CFG_FILE_PATHS_H_
#define __CFG_FILE_PATHS_H_

#include "dptr.h"
#include "gui/configuration/configpage.h"

class FileSearchPath;
class QFileInfo;

class CFGFilePaths : public ConfigPage
{
	Q_OBJECT

public:
	CFGFilePaths(QWidget *parent = nullptr);
	~CFGFilePaths() override;

	void readSettings() override;
	Validation validate() override;

protected:
	QIcon icon() const override;

	QString name() const override
	{
		return tr("File paths");
	}

	void saveSettings() override;

private:
	DPtr<CFGFilePaths> d;

	void addPath(const FileSearchPath &fileSearchPath);
	void addPathToTable(const FileSearchPath &fileSearchPath);
	bool isPathAlreadyDefined(const QString &path) const;
	void reject_();
	QString validatePath(const QString &path) const;

private slots:
	void btnAddWadPath_Click();
	void btnBrowseWadPath_Click();
	void btnRemoveWadPath_Click();
	void cbResolveTemplatedPathsPlaceholders_Toggled(bool state);
};

#endif
